const popup = document.getElementById("skill-popup");

document.querySelectorAll(".skill-tag").forEach(btn => {
    btn.addEventListener("mouseover", () => {
        const skill = btn.getAttribute("data-skill");
        const percent = btn.getAttribute("data-percent");
        const text = btn.getAttribute("data-text");

        popup.innerHTML = `
            <div style="position:relative;">
                <svg>
                    <circle class="bg" cx="60" cy="60" r="50"></circle>
                    <circle class="progress" cx="60" cy="60" r="50"></circle>
                </svg>
                <div class="circle-text">${percent}%</div>
            </div>
            <h3>${skill}</h3>
            <small>${text}</small>
        `;

        const rect = btn.getBoundingClientRect();
        popup.style.left = rect.left + "px";
        popup.style.top = rect.bottom + window.scrollY + "px";
        popup.style.display = "block";

        const progress = popup.querySelector(".progress");
        progress.style.strokeDashoffset = 314; 
        const offset = 314 - (314 * percent) / 100;
        setTimeout(() => {
            progress.style.strokeDashoffset = offset;
        }, 50);

        btn.addEventListener("mouseleave", () => {
            popup.style.display = "none";
            popup.innerHTML = '';
        }, { once: true }); 
    });
});

const lightbox = document.getElementById('lightbox');
const closeBtn = lightbox.querySelector('.close');
const frame = lightbox.querySelector('.lightbox-frame');

document.querySelectorAll('.project-card').forEach(card => {
    card.addEventListener('click', () => {
        const type = card.getAttribute('data-type');
        const title = card.getAttribute('data-title');

        if (type === "preview") {
    const src = card.getAttribute('data-src');
    frame.innerHTML = `
        <h3>${title}</h3>
        <iframe src="${src}" frameborder="0" allowfullscreen></iframe>
    `;



        } else if (type === "link") {
            const desc = card.getAttribute('data-desc');
            const link = card.getAttribute('data-link');
            frame.innerHTML = `
                <h3>${title}</h3>
                <p>${desc}</p>
                <a href="${link}" target="_blank" class="btn">View Project</a>
            `;
        }

        lightbox.style.display = 'flex';
    });
});

// Close Lightbox
closeBtn.addEventListener('click', () => {
    lightbox.style.display = 'none';
    frame.innerHTML = '';
});
window.addEventListener('click', (e) => {
    if (e.target === lightbox) {
        lightbox.style.display = 'none';
        frame.innerHTML = '';
    }
});
